DECLARE @TABELA VARCHAR(100)
DECLARE @COLUNA VARCHAR(100)
DECLARE @CONSTRAINT VARCHAR(100)
DECLARE @SQLSTRING NVARCHAR(500);

DECLARE RS CURSOR FOR 
SELECT T.NAME, C.NAME, O.NAME 
FROM SYS.TABLES T  

INNER JOIN SYS.COLUMNS C ON 
C.OBJECT_ID = T.OBJECT_ID 
 

INNER JOIN SYS.DEFAULT_CONSTRAINTS O ON
O.PARENT_OBJECT_ID = T.OBJECT_ID 
AND O.PARENT_COLUMN_ID = C.COLUMN_ID 

WHERE T.NAME = 'RC_CLI_CONV_RC_CLI'
AND O.TYPE = 'D'
AND C.NAME IN ('STS_CRED', 'STS_ATIVO')

OPEN RS

FETCH NEXT FROM RS 
INTO @TABELA, @COLUNA, @CONSTRAINT

WHILE @@FETCH_STATUS = 0
BEGIN

	SET @SQLSTRING = N'ALTER TABLE RC_CLI_CONV_RC_CLI DROP CONSTRAINT ' + @CONSTRAINT 
	
	EXECUTE SP_EXECUTESQL @SQLSTRING;
	
	SET @SQLSTRING = N'ALTER TABLE RC_CLI_CONV_RC_CLI ADD CONSTRAINT DF_RC_CLI_CONV_RC_CLI_' + @COLUNA + ' DEFAULT (0) FOR ' + @COLUNA 
	
	EXECUTE SP_EXECUTESQL @SQLSTRING;
                      
	FETCH NEXT FROM RS 
	INTO @TABELA, @COLUNA, @CONSTRAINT
END

CLOSE RS;
DEALLOCATE RS; 